//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#include "../Auxiliar/C_Terminal.mqh"
//+------------------------------------------------------------------+
#define def_PATH_BTN "Images\\Market Replay\\Chart Trade"
#define def_BTN_BUY	def_PATH_BTN + "\\BUY.bmp"
#define def_BTN_SELL	def_PATH_BTN + "\\SELL.bmp"
#define def_BTN_DT	def_PATH_BTN + "\\DT.bmp"
#define def_BTN_SW	def_PATH_BTN + "\\SW.bmp"
#define def_BTN_MAX	def_PATH_BTN + "\\MAX.bmp"
#define def_BTN_MIN	def_PATH_BTN + "\\MIN.bmp"
#define def_IDE_RAD	def_PATH_BTN + "\\IDE_RAD.tpl"
//+------------------------------------------------------------------+
#resource "\\" + def_BTN_BUY
#resource "\\" + def_BTN_SELL
#resource "\\" + def_BTN_DT
#resource "\\" + def_BTN_SW
#resource "\\" + def_BTN_MAX
#resource "\\" + def_BTN_MIN
#resource "\\" + def_IDE_RAD as string IdeRad;
//+------------------------------------------------------------------+
class C_AdjustTemplate
{
	private	:
		string m_szName[],
				m_szFind[],
				m_szReplace[],
				m_szFileName;
		int 	m_maxIndex,
				m_FileIn,
				m_FileOut;
		bool 	m_bFirst;
//+------------------------------------------------------------------+
	public	:
//+------------------------------------------------------------------+
		C_AdjustTemplate(const string szFile, const bool bFirst = false)
			:m_maxIndex(0),
			 m_szFileName(szFile),
			 m_bFirst(bFirst),
			 m_FileIn(INVALID_HANDLE),
			 m_FileOut(INVALID_HANDLE)
			{
				if (m_bFirst)
				{
					int handle = FileOpen(m_szFileName, FILE_TXT | FILE_WRITE);
					FileWriteString(handle, IdeRad);
					FileClose(handle);
				}
				if ((m_FileIn = FileOpen(m_szFileName, FILE_TXT | FILE_READ)) == INVALID_HANDLE)	SetUserError(C_Terminal::ERR_FileAcess);
				if ((m_FileOut = FileOpen(m_szFileName + "_T", FILE_TXT | FILE_WRITE)) == INVALID_HANDLE) SetUserError(C_Terminal::ERR_FileAcess);
			}
//+------------------------------------------------------------------+
		~C_AdjustTemplate()
			{
				FileClose(m_FileIn);
				FileClose(m_FileOut);
				FileMove(m_szFileName + "_T", 0, m_szFileName, FILE_REWRITE);
				ArrayResize(m_szName, 0);
				ArrayResize(m_szFind, 0);
				ArrayResize(m_szReplace, 0);
			}
//+------------------------------------------------------------------+
		void Add(const string szName, const string szFind, const string szReplace)
			{
				m_maxIndex++;
				ArrayResize(m_szName, m_maxIndex);
				ArrayResize(m_szFind, m_maxIndex);
				ArrayResize(m_szReplace, m_maxIndex);
				m_szName[m_maxIndex - 1] = szName;
				m_szFind[m_maxIndex - 1] = szFind;
				m_szReplace[m_maxIndex - 1] = szReplace;
			}
//+------------------------------------------------------------------+
		string Get(const string szName, const string szFind)
			{
				for (int c0 = 0; c0 < m_maxIndex; c0++) if ((m_szName[c0] == szName) && (m_szFind[c0] == szFind)) return m_szReplace[c0];
				
				return NULL;
			}
//+------------------------------------------------------------------+
		bool Execute(void)
			{
				string sz0, tmp, res[];
				int count0 = 0, i0;
								
				if ((m_FileIn == INVALID_HANDLE) || (m_FileOut == INVALID_HANDLE)) return false;
				while (!FileIsEnding(m_FileIn))
				{
					sz0 = FileReadString(m_FileIn);
					if (sz0 == "<object>") count0 = 1;
					if (sz0 == "</object>") count0 = 0;
					if (count0 > 0) if (StringSplit(sz0, '=', res) > 1)
					{
						if ((m_bFirst) && ((res[0] == "bmpfile_on") || (res[0] == "bmpfile_off")))
							sz0 = res[0] + "=\\Indicators\\Chart Trade.ex5::" + def_PATH_BTN + res[1];
						i0 = (count0 == 1 ? 0 : i0);
						for (int c0 = 0; (c0 < m_maxIndex) && (count0 == 1); i0 = c0, c0++) count0 = (res[1] == (tmp = m_szName[c0]) ? 2 : count0);
						for (int c0 = i0; (c0 < m_maxIndex) && (count0 == 2); c0++) if ((res[0] == m_szFind[c0]) && (tmp == m_szName[c0]))
						{
							if (StringLen(m_szReplace[c0])) sz0 =  m_szFind[c0] + "=" + m_szReplace[c0];
							else m_szReplace[c0] = res[1];
						}
					}
					if (FileWriteString(m_FileOut, sz0 + "\r\n") < 2) return false;
				};
				
				return true;
			}
//+------------------------------------------------------------------+
};
//+------------------------------------------------------------------+
#undef def_BTN_BUY
#undef def_BTN_SELL
#undef def_BTN_DT
#undef def_BTN_SW
#undef def_BTN_MAX
#undef def_BTN_MIN
#undef def_IDE_RAD
#undef def_PATH_BTN
//+------------------------------------------------------------------+